<!DOCTYPE html>

<html lang="<?php echo e(App::getLocale()); ?>">
<!--begin::Head-->

<head>
    <title><?php echo e(__('auth.sign_in')); ?></title>
    <meta charset="utf-8" />


    <link rel="shortcut icon" href="<?php echo e($setting->image); ?>" />

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700" />

    <link href="<?php echo e(asset('assets/plugins/global/plugins.bundle.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/css/style.bundle.css')); ?>" rel="stylesheet" type="text/css" />

    <script></script>
</head>


<body id="kt_body" class="app-blank" dir="<?php echo e(app()->getLocale() == 'ar' ? 'rtl' : 'ltr'); ?>">
    <!--end::Theme mode setup on page load-->
    <!--begin::Root-->

    <div class="d-flex flex-column flex-root" id="kt_app_root">
        <!--begin::Authentication - Sign-in -->
        <div class="d-flex gap-2 w-full justify-around m-auto my-2 ">
            <?php $__currentLoopData = LaravelLocalization::getSupportedLocales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(LaravelLocalization::getLocalizedURL($name)); ?>"
                    class="btn btn-light <?php echo e(LaravelLocalization::getCurrentLocale() == $name ? 'active' : ''); ?>"
                    <?php echo e(LaravelLocalization::getCurrentLocale() == $name ? 'style=pointer-events:none; cursor: not-allowed' : ''); ?>>
                    <?php echo e($value['native']); ?>

                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="d-flex flex-column flex-lg-row flex-column-fluid">
            <!--begin::Body-->
            <div class="d-flex flex-column flex-lg-row-fluid w-lg-50 p-10 order-2 order-lg-1">
                <!--begin::Form-->
                <div class="d-flex flex-center flex-column flex-lg-row-fluid">

                    <!--begin::Wrapper-->
                    <div class="w-lg-500px p-10">
                        <!--begin::Form-->
                        <form class="form w-100" method="POST" action="<?php echo e(route('post.login')); ?>">
                            <?php echo csrf_field(); ?>
                            <!--begin::Heading-->
                            <div class="text-center mb-11">
                                <!--begin::Title-->
                                <h1 class="text-dark fw-bolder mb-3"><?php echo e(__('auth.sign_in')); ?></h1>
                                <!--end::Title-->
                                <?php echo $__env->make('AdminPanel.partials.errors', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                            </div>
                            <!--begin::Heading-->

                            <!--begin::Input group=-->
                            <div class="fv-row mb-8">
                                <!--begin::Email-->
                                <input type="email" placeholder="<?php echo e(__('auth.email')); ?>" name="email"
                                    autocomplete="off" class="form-control bg-transparent" />
                                <!--end::Email-->
                            </div>
                            <!--end::Input group=-->
                            <div class="fv-row mb-3">
                                <!--begin::Password-->
                                <input type="password" placeholder="<?php echo e(__('auth.password')); ?>" name="password"
                                    autocomplete="off" class="form-control bg-transparent" />
                                <!--end::Password-->
                            </div>
                            <!--end::Input group=-->

                            <!--begin::Submit button-->
                            <div class="d-grid mb-10">
                                <input type="submit" class="btn btn-primary" value="<?php echo e(__('auth.sign_in')); ?>">
                            </div>
                            <!--end::Submit button-->
                        </form>
                        <!--end::Form-->
                    </div>
                    <!--end::Wrapper-->
                </div>
                <!--end::Form-->

            </div>
            <!--end::Body-->
            <!--begin::Aside-->
            <div
                class="d-flex align-items-center flex-lg-row-fluid w-lg-50 bgi-size-cover bgi-position-center order-1 order-lg-2">
                <img src="<?php echo e($setting->image); ?>" class="w-100"
                    onerror="this.onerror=null;this.src='<?php echo e(asset('assets/media/svg/files/blank-image.svg')); ?>';">
            </div>
            <!--end::Aside-->
        </div>
        <!--end::Authentication - Sign-in-->
    </div>
    <!--end::Root-->
    <!--begin::Javascript-->
    <script>
        var hostUrl = "assets/";
    </script>
    <!--begin::Global Javascript Bundle(mandatory for all pages)-->
    <script src="<?php echo e(asset('assets/plugins/global/plugins.bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/scripts.bundle.js')); ?>"></script>
    <!--end::Global Javascript Bundle-->
    <!--begin::Custom Javascript(used for this page only)-->
    <script src="<?php echo e(asset('assets/js/custom/authentication/sign-in/general.js')); ?>"></script>
    <!--end::Custom Javascript-->
    <!--end::Javascript-->
</body>
<!--end::Body-->

</html>
<?php /**PATH /home/oday/public_html/mazdashboard.alialzahabia.com/resources/views/AdminPanel/Authentication/login.blade.php ENDPATH**/ ?>