<?php

use App\Http\Controllers\API\Agencies\AgencyController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\Article\ArticleController;
use App\Http\Controllers\API\Auth\AuthController;
use App\Http\Controllers\API\Auth\PasswordController;
use App\Http\Controllers\API\Intro\IntroController;
use App\Http\Controllers\API\Slider\SliderController;
use App\Http\Controllers\API\Country\CountryController;
use App\Http\Controllers\API\HowWeWork\HowWeWorkController;
use App\Http\Controllers\API\Auction\AuctionController;
use App\Http\Controllers\API\Auction\FavouriteController;
use App\Http\Controllers\API\Auction\SearchController;
use App\Http\Controllers\API\Category\CategoryController;
use App\Http\Controllers\API\Pages\PageController;
use App\Http\Controllers\API\ContactUs\ContactUsController;
use App\Http\Controllers\API\Dates\DateController;
use App\Http\Controllers\API\Map\MapController;
use App\Http\Controllers\API\Features\FeatureController;
use App\Http\Controllers\API\Home\HomeController;
use App\Http\Controllers\API\Notification\NotificationController;
use App\Http\Controllers\API\Setting\SettingController;
use App\Http\Middleware\IsVerifiedMiddleware;

Route::group([
    'prefix'             => '{local}',
    'middleware'         => 'SetApiLocale',
], function () {

    Route::get('countries', [CountryController::class, 'index']);
    Route::get('cities/{id}', [CountryController::class, 'cities']);
    Route::get('areas/{id}', [CountryController::class, 'areas']);

    //features

    Route::get('features/{id}', FeatureController::class);

    // Auth
    Route::post('login', [AuthController::class, 'login']);
    Route::post('signup', [AuthController::class, 'signup']);
    Route::post('code/resend', [AuthController::class, 'resendCode']);
    Route::post('verify', [AuthController::class, 'verify']);
    Route::post('social/login', [AuthController::class, 'socialLogin']);

    // password
    Route::Post('forgetPassword',  [PasswordController::class, 'forgetPassword']);
    Route::Post('verfyCode', [PasswordController::class, 'confirmOTP']);
    Route::Post('resetPassword', [PasswordController::class, 'resetPassword']);

    //settings
    Route::get('settings', SettingController::class);

    Route::middleware(['auth:client', IsVerifiedMiddleware::class, 'isActive:client'])->group(function () {
        Route::get('profile', [AuthController::class, 'profile']);
        Route::post('update-profile', [AuthController::class, 'updateProfile']);
        Route::post('logout', [AuthController::class, 'logout']);
        Route::post('change-password', [PasswordController::class, 'changePassword']);
        Route::post('delete-account', [AuthController::class, 'deleteAccount']);
        Route::post('update-fcm-token', [AuthController::class, 'updateFCMToken']);
        Route::apiResource('favourites', FavouriteController::class)->only(['index', 'store']);
        Route::get('notifications/mark-as-read', [NotificationController::class, 'markAllRead']);
        Route::get('notifications/count', [NotificationController::class, 'count']);
        Route::resource('notifications', NotificationController::class)->only(['index', 'show', 'destroy']);
        Route::get('searches', SearchController::class);
    });

    // pages
    Route::get('pages', [PageController::class, 'index']);
    Route::get('page/{id}', [PageController::class, 'show']);

    // Article
    Route::get('articles', [ArticleController::class, 'index']);
    Route::get('article/{id}', [ArticleController::class, 'show']);

    // Intro
    Route::get('intros', [IntroController::class, 'index']);
    Route::get('intro/{id}', [IntroController::class, 'show']);

    // HowWeWork
    Route::get('howweworks', [HowWeWorkController::class, 'index']);
    Route::get('howwework/{id}', [HowWeWorkController::class, 'show']);

    // Slider
    Route::get('sliders', [SliderController::class, 'index']);
    Route::get('slider/{id}', [SliderController::class, 'show']);

    // Ctaegory
    Route::get('categories', [CategoryController::class, 'index']);
    Route::get('category/{id}', [CategoryController::class, 'show']);

    // Auction
    Route::get('auctions', [AuctionController::class, 'index']);
    Route::get('auction/{id}', [AuctionController::class, 'show']);

    // ContactUs
    Route::post('contactUs', [ContactUsController::class, 'store']);

    //Home
    Route::get('home', HomeController::class);

    //Dates

    Route::get('dates', DateController::class);

    //Map
    Route::get('map', MapController::class);


    //Agencies

    Route::get('agencies', AgencyController::class);
});
