<x-select-two name='country_id' id='country_id'>
    @foreach ($countries as $country)
        <option value="{{ $country->id }}"
            {{ old('country_id', isset($model) ? $model->country_id : '') == $country->id ? 'selected' : '' }}>
            {{ $country->name }}</option>
    @endforeach
</x-select-two>


<script>
    const country = document.getElementById('country_id');

    function toggleCountry() {
        country_id = country.value;


        if (country_id == '') {
            $('#city_id').empty();
            $('#city_id').append('<option>??</option>');
            return;
        }
        $.ajax({
            url: "{{ url('api/' . App::getLocale() . '/cities/') }}/" + country_id,
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                $('#city_id').empty();
                $('#city_id').append('<option>??</option>');
                $.each(data.data, function(key, value) {

                    $('#city_id').append('<option value="' + value.id +
                        '">' +
                        value.name + '</option>');
                })
            },
            error: function(error) {
                console.error(error);
            }
        });

    }

    document.addEventListener("DOMContentLoaded", function() {
        $('#country_id').on('change', toggleCountry);
    });
</script>
