<x-select-two name='city_id' id='city_id' :isSelect2=false>
    @foreach ($cities as $city)
        <option value="{{ $city->id }}"
            {{ old('city_id', isset($model) ? $model->city_id : '') == $city->id ? 'selected' : '' }}>
            {{ $city->name }}</option>
    @endforeach
</x-select-two>


<script>
    const city = document.getElementById('city_id');

    function toggleCity() {
        city_id = city.value;


        if (city_id == '') {
            $('#area_id').empty();
            $('#area_id').append('<option>??</option>');
            return;
        }
        $.ajax({
            url: "{{ url('api/' . App::getLocale() . '/areas/') }}/" + city_id,
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                $('#area_id').empty();
                $('#area_id').append('<option>??</option>');
                $.each(data.data, function(key, value) {

                    $('#area_id').append('<option value="' + value.id +
                        '">' +
                        value.name + '</option>');
                })
            },
            error: function(error) {
                console.error(error);
            }
        });

    }

    document.addEventListener("DOMContentLoaded", function() {

        $('#city_id').on('change', toggleCity);
    });
</script>
