<!--begin::Table-->
<table id="kt_datatable_dom_positioning" class="table table-striped table-row-bordered gy-5 gs-7 border rounded">
    <!--begin::Thead-->
    <thead>
        <tr class="fw-6 fw-semibold text-gray-600">
            <th>{{ __('lang.image') }}</th>
            <th>{{ __('lang.position') }}</th>
            <th>{{ __('lang.actions') }}</th>
        </tr>
    </thead>
    <!--end::Thead-->
    <!--begin::Tbody-->
    <tbody>
        @foreach ($sliders as $slider)
            <tr>
                <td>
                    <x-image-tag :url="$slider->image"></x-image-tag>
                </td>
                <td>
                    <span class="badge badge-light-success fs-7 fw-bold">{{ $slider->position }}</span>
                </td>
                <td>
                    @if (auth()->user()->can('update sliders'))
                        <a href="{{ route('sliders.edit', $slider->id) }}" class="btn btn-sm btn-light me-2">
                            <i class="bi bi-pencil-square"></i>
                        </a>
                    @endif

                    @if (auth()->user()->can('delete sliders'))
                        <a data-url="{{ route('sliders.destroy', $slider->id) }}" type='button'
                            class="btn btn-sm btn-danger me-2 delete-btn">
                            <i class="bi bi-file-x-fill"></i>
                        </a>
                    @endif

                </td>
            </tr>
        @endforeach
    </tbody>
    <!--end::Tbody-->
</table>
<!--end::Table-->
