@isset($slider)
    @method('PUT')
    <input type="hidden" value="{{ $slider->id }}" name="id">
@endisset
@csrf
<x-localization>
    @foreach (LaravelLocalization::getSupportedLocales() as $name => $value)
        <div class="tab-pane fade {{ LaravelLocalization::getCurrentLocale() == $name ? 'show active' : '' }}"
             id="{{ $name }}" role="tabpanel" aria-labelledby="{{ $name }}-tab">

            <!--begin::Input group-->
            <div class="row mb-3">
                <!--begin::Label-->
                <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.title') }}</label>
                <!--end::Label-->

                <!--begin::Col-->
                <div class="col-lg-8">
                    <!--begin::Row-->
                    <div class="row">
                        <!--begin::Col-->
                        <div class="col-lg-12 fv-row fv-plugins-icon-container">
                            <input type='text' name="{{ $name }}[title]"
                                   class="form-control form-control-lg form-control-solid mb-3 mb-lg-0"
                                   placeholder="{{ __('lang.title') }}"
                                  value="{{  old($name . '.title', isset($slider) ? $slider->translateOrNew($name)->title : '') }}">
                        </div>
                        <!--end::Col-->
                    </div>
                    <!--end::Row-->
                </div>
                <!--end::Col-->
            </div>
            <!--end::Input group-->
        </div>
    @endforeach
</x-localization>
<div class="card-body border-top p-9">
    <div class="row mb-3">
        <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.sort') }}</label>
        <div class="col-lg-8">
            <input type='number' name="order" class="form-control form-control-lg form-control-solid mb-3 mb-lg-0 "
                value="{{ old('order', isset($slider) ? $slider->order : '') }}">
        </div>
    </div>
    <div class="row mb-3">
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.position') }}</label>
    <div class="col-lg-8">
        <select name="position" class="form-select form-select-solid form-select-lg">
            @php
                $positions = ['top' => 'Top', 'center' => 'Center', 'bottom' => 'Bottom'];
                $selected = old('position', isset($slider) ? $slider->position : 'top');
            @endphp
            @foreach ($positions as $key => $label)
                <option value="{{ $key }}" {{ $selected == $key ? 'selected' : '' }}>{{ $label }}</option>
            @endforeach
        </select>
    </div>
</div>

    @php
        if (isset($slider)) {
            $model = $slider;
        } else {
            $model = new \App\Models\Slider();
        }
    @endphp
    <x-image :model="$model" label='image'>
    </x-image>

</div>
