@isset($role)
    @method('PUT')
@endisset
@csrf
<div class="card-body border-top p-9">
    @isset($role)
        <input type="hidden" value="{{ $role->id }}" name='id'>
    @endisset
    <!--begin::Input group-->
    <div class="row mb-6">
        <!--begin::Label-->
        <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.name') }}</label>
        <!--end::Label-->

        <!--begin::Col-->
        <div class="col-lg-8">
            <!--begin::Row-->
            <div class="row">
                <!--begin::Col-->
                <div class="col-lg-12 fv-row fv-plugins-icon-container">
                    <input type="text" name="name"
                        class="form-control form-control-lg form-control-solid mb-3 mb-lg-0"
                        placeholder="{{ __('lang.name') }}" value="{{ old('name', $role->name ?? '') }}">
                    <div class="fv-plugins-message-container fv-plugins-message-container--enabled invalid-feedback">
                    </div>
                </div>
                <!--end::Col-->
            </div>
            <!--end::Row-->
        </div>
        <!--end::Col-->
    </div>
    <!--end::Input group-->

    <!--begin::Input group-->
    <div class="row mb-6">
        <!--begin::Label-->
        <label class="row col-form-label required fw-semibold fs-6">{{ __('lang.permession') }}</label>
        <!--end::Label-->

        <!--begin::Col-->
        <div class="col-lg-12">
            <!--begin::Row-->
            <div class="row w-100">
                @php
                    $c = 1;
                @endphp
                @foreach ($pages as $page)
                    <!--begin::Col-->
                    <div class="col-2">
                        <label class="row col-form-label  fw-semibold fs-6">{{ __('lang.' . $page) }}</label>
                    </div>
                    <div class="col-10 ">
                        @foreach ($permessions as $permission)
                            <span class="col-3">
                                <input type="checkbox" name='permissions[]'
                                    {{ in_array($c, old('permissions', isset($role) ? $role->permission_ids : [])) ? 'checked' : '' }}
                                    value='{{ $c++ }}'>
                                <label class="col-form-label  fw-semibold fs-6">{{ __('lang.' . $permission) }}</label>
                            </span>
                        @endforeach
                    </div>
                @endforeach
                <!--end::Col-->
            </div>
            <!--end::Row-->
        </div>
        <!--end::Col-->
    </div>
    <!--end::Input group-->

</div>
