@isset($news)
    @method('PUT')
    <input type="hidden" value="{{ $notification->id }}" name="id">
@endisset
@csrf

<x-localization>
    @foreach (LaravelLocalization::getSupportedLocales() as $name => $value)
        <div class="tab-pane fade {{ LaravelLocalization::getCurrentLocale() == $name ? 'show active' : '' }}"
            id="{{ $name }}" role="tabpanel" aria-labelledby="{{ $name }}-tab">
            <!--begin::Input group-->
            <div class="row mb-3">
                <!--begin::Label-->
                <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.title') }}</label>
                <!--end::Label-->
                <!--begin::Col-->
                <div class="col-lg-8">
                    <!--begin::Row-->
                    <div class="row">
                        <!--begin::Col-->
                        <div class="col-lg-12 fv-row fv-plugins-icon-container">
                            <input type='text' name="{{ $name }}[title]"
                                class="form-control form-control-lg form-control-solid mb-3 mb-lg-0 "
                                placeholder="{{ __('lang.title') }}"
                                value="{{ old($name . '.title', isset($news) ? $news->translateOrNew($name)->title : '') }}">

                        </div>
                        <!--end::Col-->
                    </div>
                    <!--end::Row-->
                </div>
                <!--end::Col-->
            </div>
            <!--end::Input group-->
            <!--begin::Input group-->
            <div class="row mb-3">
                <!--begin::Label-->
                <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.body') }}</label>
                <!--end::Label-->

                <!--begin::Col-->
                <div class="col-lg-8">
                    <!--begin::Row-->
                    <div class="row">
                        <!--begin::Col-->
                        <div class="col-lg-12 fv-row fv-plugins-icon-container">
                            <textarea name="{{ $name }}[body]" class="form-control form-control-lg form-control-solid mb-3 mb-lg-0">{{ old($name . '.body', isset($page) ? $page->translateOrNew($name)->body : '') }}
                                </textarea>

                        </div>
                        <!--end::Col-->
                    </div>
                    <!--end::Row-->
                </div>
                <!--end::Col-->
            </div>
            <!--end::Input group-->


        </div>
    @endforeach
</x-localization>
<!--begin::Input group-->
<div class="card-body border-top p-9">
    <div class="row mb-6">
        <!--begin::Label-->
        <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.clients') }}</label>
        <!--end::Label-->


        <x-select-two name='client_id' id='client_id' :isSelect=true :multiple=true>
            <option value="all">{{ __('lang.send_all') }}</option>
            @foreach ($clients as $client)
                <option value="{{ $client->id }}">
                    {{ $client->name }}
                </option>
            @endforeach
        </x-select-two>
    </div>
    <!--end::Col-->
</div>
