<!--begin::Table-->
<table id="kt_datatable_dom_positioning" class="table table-striped table-row-bordered gy-5 gs-7 border rounded">
    <!--begin::Thead-->
    <thead>
        <tr class="fw-6 fw-semibold text-gray-600">
            <th>{{ __('lang.name') }}</th>
            <th>{{ __('lang.email') }}</th>
            <th>{{ __('lang.phone') }}</th>
            <th>{{ __('lang.message') }}</th>
            <th>{{ __('lang.seen') }}</th>
            <th>{{ __('lang.actions') }}</th>
        </tr>
    </thead>
    <!--end::Thead-->
    <!--begin::Tbody-->
    <tbody>
        @foreach ($messages as $contact)
            <tr>
                <td>

                    <span class="badge badge-light-success fs-7 fw-bold">{{ $contact->name }}
                    </span>
                </td>
                <td>{{ $contact->email }}</td>
                <td>
                    {{ $contact->phone }}
                </td>

                <td class="text-wrap overflow-scroll">
                    {{ $contact->message }}
                </td>
                <td>
                    <span
                        class="badge
                    badge-{{ $contact->seen ? 'light-success' : 'warning' }} fs-7 fw-bold">
                        {{ $contact->seen_text }}</span>
                </td>
                <td>
                    @if (auth()->user()->can('update messages'))
                        @if (!$contact->seen)
                            <a href="{{ route('messages.show', $contact->id) }}">
                                <i class="bi bi-eye fs-3"></i>
                            </a>
                        @endif
                    @endif
                </td>
            </tr>
        @endforeach
    </tbody>
    <!--end::Tbody-->
</table>
<!--end::Table-->
