@isset($feature)
    @method('PUT')
    <input type="hidden" value="{{ $feature->id }}" name="id">
@endisset

@csrf

<x-localization>
    @foreach (LaravelLocalization::getSupportedLocales() as $name => $value)
        <div class="tab-pane fade {{ LaravelLocalization::getCurrentLocale() == $name ? 'show active' : '' }}"
            id="{{ $name }}" role="tabpanel" aria-labelledby="{{ $name }}-tab">

            <!--begin::Input group-->
            <div class="row mb-3">
                <!--begin::Label-->
                <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.name') }}</label>
                <!--end::Label-->

                <!--begin::Col-->
                <div class="col-lg-8">
                    <!--begin::Row-->
                    <div class="row">
                        <!--begin::Col-->
                        <div class="col-lg-12 fv-row fv-plugins-icon-container">
                            <input type='text' name="{{ $name }}[name]"
                                class="form-control form-control-lg form-control-solid mb-3 mb-lg-0"
                                placeholder="{{ __('lang.name') }}"
                                value="{{ old($name . '.name', isset($feature) ? $feature->translateOrNew($name)->name : '') }}">
                        </div>
                        <!--end::Col-->
                    </div>
                    <!--end::Row-->
                </div>
                <!--end::Col-->
            </div>
            <!--end::Input group-->
        </div>
    @endforeach
</x-localization>

<div class="card-body border-top p-9">
    <!-- Form Repeater for Attributes -->
    <div class="d-flex justify-content-center gap-2">
        <button type="button" id="add_attribute" class="btn btn-sm btn-success  " onclick="addAttribute()">
            <i class="bi bi-plus"></i> </button>
        <h1>{{ __('lang.attributes') }}</h1>
    </div>
    <hr>

    <!-- قائمة الألوان -->
    <div id="attributes_section">

        @isset($feature)
            @foreach ($feature->attributes as $attribute)
                @include('AdminPanel.features.attributes', [
                    'attribute' => $attribute,
                    'counter' => $attribute->id,
                ])
            @endforeach
        @endisset

    </div>
</div>


<script>
    let counter = `{{ isset($feature) ? $feature->attributes->max('id') + 1 : 0 }}`;
    let container = document.getElementById('attributes_section');

    function addAttribute() {
        $.ajax({
            url: "{{ url(App::getLocale() . '/add/attribute') }}/" + counter,
            type: 'GET',
            success: function(data) {
                $(container).append(`${data}`);
                counter++;
            },
            error: function(error) {
                console.error(error);
            }
        });

    }

    function deleteAttribute(id) {
        $(`#attribute-${id}`).remove();
    }
</script>
