<div class="row mt-4" id="attribute-{{ $counter }}">
    @isset($attribute)
        <input type="hidden" value="{{ $attribute->id }}" name="attributes[{{ $counter }}][id]">
    @endisset
    <div class="col-lg-12 mb-6">
        <label> {{ __('lang.name') }} </label>
        @foreach (LaravelLocalization::getSupportedLocales() as $name => $value)
            <input type="text" name="attributes[{{ $counter }}][{{ $name }}][name]"
                id="attribute_id_{{ $counter }}"
                class="form-control form-control-lg form-control-solid mb-3 mb-lg-0 my-2"
                placeholder="{{ __('lang.name') }} {{ $name }}"
                value="{{ old('attributes.' . $counter . '.' . $name . 'name', isset($attribute) ? $attribute->getTranslation($name)->name : '') }}">
        @endforeach

    </div>

    <div class="col-lg-12 mb-6">
        <label> {{ __('lang.image') }} </label>

        <input type="file" name="attributes[{{ $counter }}][image]" id="attribute_image_{{ $counter }}"
            class="form-control form-control-lg form-control-solid mb-3 mb-lg-0 my-2">
        @isset($attribute)
            <x-image-tag :url="$attribute->image"></x-image-tag>
        @endisset
    </div>

    @isset($attribute)
        <div class="row d-flex justify-content-end">
            <a href="{{ route('attribute.delete', $attribute->id) }}" class="btn btn-danger btn-sm"><i
                    class="fas fa-trash"></i></a>
        </div>
    @else
        <button type="button" class="btn btn-danger mt-4" onclick="deleteAttribute({{ $counter }})">
            <i class="fas fa-trash"></i></button>
    @endisset
</div>
