@php
    $attribute_id = 'feature_attribute_' . $counter;
    if (isset($feature)) {
        $model = $feature;
    } else {
        $model = null;
    }
@endphp
<div class="row m-4" id="feature-{{ $counter }}">
    @isset($feature)
        <input type="hidden" value="{{ $feature->id }}" name="features[{{ $counter }}][id]">
    @endisset
    <div class="col-lg-12 mb-6">
        <label> {{ __('lang.features') }} </label>
        <x-feature-select :model="$model" :attributeid="$attribute_id" :counter="$counter"
            name="features[{{ $counter }}][feature_id]"></x-feature-select>
    </div>

    <div class="col-lg-12 mb-6">
        <label> {{ __('lang.attributes') }} </label>
        <x-attribute-select :model="$model" :id="$attribute_id" :featureid="$model ? $model->feature_id : null"
            name="features[{{ $counter }}][feature_attribute_id]"></x-attribute-select>
    </div>
    <!--begin::Input group-->
    <div class="col-lg-12 mb-6">
        <!--begin::Label-->
        <label>{{ __('lang.value') }}</label>
        <!--end::Label-->


        <!--begin::Col-->
        <div class="col-lg-12 fv-row fv-plugins-icon-container">
            <input type='text' name="features[{{ $counter }}][value]"
                class="form-control form-control-lg form-control-solid mb-3 mb-lg-0 w-75"
                placeholder="{{ __('lang.value') }}"
                value="{{ old('features.' . $counter . '.value', isset($feature) ? $feature->value : '') }}">

        </div>
        <!--end::Col-->
    </div>
    <!--end::Row-->

    <!--end::Input group-->

    @isset($feature)
        <div class="row d-flex justify-content-end">
            <a href="{{ route('feature.delete', $feature->id) }}" class="btn btn-danger btn-sm"><i
                    class="fas fa-trash"></i></a>
        </div>
    @else
        <button type="button" class="btn btn-danger mt-4" onclick="deleteFeature({{ $counter }})">
            <i class="fas fa-trash"></i></button>
    @endisset


</div>
