<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageTranslation;

class PageSeeder extends Seeder
{
    public function run()
    {
        $pages = [
            [
                'en' => [
                    'title'   => 'About Us',
                    'content' => 'This is the About Us page content in English.',
                ],
                'ar' => [
                    'title'   => 'من نحن',
                    'content' => 'هذه هي محتويات صفحة من نحن باللغة العربية.',
                ],
            ],
            [
                'en' => [
                    'title'   => 'Terms of Service',
                    'content' => 'These are the Terms of Service in English.',
                ],
                'ar' => [
                    'title'   => 'شروط الخدمة',
                    'content' => 'هذه هي شروط الخدمة باللغة العربية.',
                ],
            ],
            [
                'en' => [
                    'title'   => 'Privacy Policy',
                    'content' => 'This is the Privacy Policy in English.',
                ],
                'ar' => [
                    'title'   => 'سياسة الخصوصية',
                    'content' => 'هذه هي سياسة الخصوصية باللغة العربية.',
                ],
            ],
        ];

        foreach ($pages as $i => $pageData) {
            if (!Page::find($i + 1)) {
                $page = Page::create();

                PageTranslation::create([
                    'page_id'  => $page->id,
                    'locale'   => 'en',
                    'title'    => $pageData['en']['title'],
                    'content'  => $pageData['en']['content'],
                ]);

                PageTranslation::create([
                    'page_id' => $page->id,
                    'locale'  => 'ar',
                    'title'   => $pageData['ar']['title'],
                    'content' => $pageData['ar']['content'],
                ]);
            }
        }
    }
}
