<?php

namespace Database\Seeders;

use App\Models\Area;
use App\Models\City;
use App\Models\Country;
use Illuminate\Database\Seeder;

class CountrySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $country = [
            'id' => 3,
            'ar' => [
                'name' => 'المملكة العربية السعودية'
            ],
            'en' => [
                'name' => 'Saudi Arabia'
            ],
        ];
        Country::updateOrCreate(['id' => $country['id']], $country);

        $data = [
            "id" => 3,
            "ar" => [
                "name" => "الرياض"
            ],
            "en" => [
                "name" => "Riyadh"
            ],
        ];
        $city = $data;
        $city['country_id'] = $country['id'];
        City::updateOrCreate(['id' => $city['id']], $city);
        $area = $data;
        $area['country_id'] = $country['id'];
        $area['city_id'] = $city['id'];
        Area::updateOrCreate(['id' => $area['id']], $area);
    }
}
