<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;
use App\Models\CategoryTranslation;

class CategorySeeder extends Seeder
{
    public function run()
    {
        if (!Category::find(1)) {

            $category = Category::create([
                'image' => 'default.png',
            ]);

            CategoryTranslation::create([
                'category_id'       => $category->id,
                'locale'            => 'en',
                'name'              => 'Lands',
            ]);

            CategoryTranslation::create([
                'category_id'       => $category->id,
                'locale'            => 'ar',
                'name'              => 'الاراضى',
            ]);
        }
    }
}
