<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::create('area_translations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('area_id')->constrained()->references('id')->on('areas')->onDelete('cascade');
            $table->string('locale');
            $table->Text('name');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('area_translations');
    }
};
