<?php

namespace App\View\Components;

use App\Models\Feature;
use App\Repositries\FeatureRepository;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class FeatureSelect extends Component
{
    public $features, $model, $featureRepository, $attributeid = null, $counter, $name = '';
    public function __construct(
        $model = null,
        $attributeid = null,
        $counter = 0,
        $name = '',
        FeatureRepository $featureRepository,
    ) {
        $this->model = $model;
        $this->featureRepository = $featureRepository;
        $this->features = $this->featureRepository->index(new Feature());
        $this->attributeid = $attributeid;
        $this->counter = $counter;
        $this->name = $name;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.feature-select');
    }
}
