<?php

namespace App\View\Components;

use App\Models\City;
use App\Repositries\MainRepository;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class CitySelect extends Component
{
    public $cities, $model, $cityRepository, $countryId = null;
    public function __construct(
        $model = null,
        MainRepository $cityRepository,
        $countryId = null
    ) {
        $this->model = $model;
        $this->cityRepository = $cityRepository;
        $this->countryId = $countryId;
        $this->cities =  $this->countryId ?  $this->cityRepository->index(City::where('country_id', $this->countryId)) : [];
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.city-select');
    }
}
