<?php

namespace App\View\Components;

use App\Models\FeatureAttribute;
use App\Repositries\MainRepository;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class AttributeSelect extends Component
{
    public  $model, $attributeRepository, $id = null, $featureid = null, $rows, $name = '';
    public function __construct(
        $model = null,
        MainRepository $attributeRepository,
        $id = null,
        $featureid = null,
        $name = ''
    ) {
        $this->model = $model;
        $this->id = $id;
        $this->attributeRepository = $attributeRepository;
        $this->featureid = $featureid;
        $this->rows = $this->featureid ? $this->attributeRepository->index(
            FeatureAttribute::where('feature_id', $this->featureid)
        ) : [];
        $this->name = $name;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.attribute-select');
    }
}
