<?php

namespace App\Repositries;

use App\Jobs\SendNotificationJob;
use App\Models\Client;
use App\Models\Designer;
use App\Models\Request;
use App\Models\Room;
use App\Models\RoomItem;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class RequestRepository
{
    public $mainRepositry;
    public $model;
    public function __construct(MainRepository $mainRepositry)
    {
        $this->mainRepositry = $mainRepositry;
        if (auth()->guard('client')->check()) {
            $this->model = auth('client')->user()->requests()->filter();
        } else if (auth()->guard('designer')->check()) {
            $this->model = auth('designer')->user()->requests()->filter();
        } else {
            $this->model = Request::filter();
        }
    }
    public function index()
    {
        return $this->mainRepositry->index($this->model->with(['client', 'designer', 'type', 'category.parent']), request()->per_page);
    }

    public function show($id)
    {
        $request = $this->mainRepositry->show($this->model, $id)->load(['client', 'designer', 'type', 'category.parent', 'designs.items.designable']);
        return $request;
    }
    public function store($data)
    {
        $data['remain'] = $data['price'];
        $request = $this->mainRepositry->create($this->model, $data);
        $this->sendNotification($request->designer_id, 'new_request', 'new_request_body', 'Designer', new Designer(), 'App\Models\Request', $request->id, ['name' => auth('client')->user()->name]);
        return $request;
    }

    public function accept($id)
    {
        $request = $this->mainRepositry->show($this->model->where('status', '0'), $id);
        $request = $this->mainRepositry->update($request, $id, ['status' => '1']);

        $this->sendNotification($request->client_id, 'request_accepted', 'request_accepted_body', 'Client', new Client(), 'App\Models\Request', $request->id, ['name' => auth('designer')->user()->name]);
        return $request;
    }

    public function pay($id)
    {
        $request = $this->mainRepositry->show($this->model->where('status', '1'), $id);
        $request = $this->mainRepositry->update($request, $id, ['status' => '2', 'remain' => $request->price - $request->deposit]);

        $this->sendNotification($request->designer_id, 'request_paid', 'request_paid_body', 'Designer', new Designer(), 'App\Models\Request', $request->id, ['name' => auth('client')->user()->name]);

        return $request;
    }

    public function submitDesigns($data, $id)
    {
        $request = $this->mainRepositry->show($this->model->where('status', '2'), $id);
        $design = $request->designs()->create($data);
        $this->submitItems($design, $data['items']);
        $this->sendNotification($request->client_id, 'design_submitted', 'design_submitted_body', 'Client', new Client(), 'App\Models\RequestDesign', $design->id, ['name' => auth('designer')->user()->name]);
        return $request;
    }

    public function finish($id)
    {
        $request = $this->mainRepositry->show($this->model->where('status', '2'), $id);
        $request = $this->mainRepositry->update($request, $id, ['status' => '3', 'remain' => 0]);
        return $request;
    }

    public function submitItems($design, $items)
    {
        foreach ($items as $item) {
            if ($item['type'] == 0) {
                $rec = $this->mainRepositry->show(Room::filter(), $item['id']);
                $item['designable_id'] = $rec->id;
                $item['designable_type'] = Room::class;
            } else {
                $rec = $this->mainRepositry->show(RoomItem::filter(), $item['id']);
                $item['designable_id'] = $rec->id;
                $item['designable_type'] = RoomItem::class;
            }
            $design->items()->create($item);
        }
    }

    public function sendNotification($id, $title, $body, $type, $model, $notifiable_type, $notifiable_id, $attributes = [])
    {
        $notification = [];
        foreach (LaravelLocalization::getSupportedLanguagesKeys() as $lang) {
            $notification[$lang] = [
                'title' => trans('lang.' . $title, [], $lang),
                'body' => trans('lang.' . $body, $attributes, $lang),
            ];
        }
        SendNotificationJob::dispatch([$id], $notification, $type, $model, $notifiable_type, $notifiable_id);
    }
}
