<?php

namespace App\Repositries;

use App\Models\Intro;

class IntroRepository
{
    public $mainRepositry;
    public $model;
    public function __construct(MainRepository $mainRepositry, Intro $model)
    {
        $this->mainRepositry = $mainRepositry;
        $this->model         = $model;
    }

    public function index()
    {
        $intros = $this->model->query();
        return $this->mainRepositry->index($intros);
    }

    public function show($id)
    {
        $intro = $this->mainRepositry->show($this->model, $id);
        return $intro;
    }

    public function store($data)
    {
        $intro = $this->mainRepositry->create($this->model, $data);
        $intro->update($data);
        return $intro;
    }

    public function update($id, $data)
    {
        $data['category_id'] = $data['category_id'] ?? Null;
        $category            = $this->mainRepositry->update($this->model, $id, $data);
        return $category;
    }

    public function destroy($id)
    {
        $this->mainRepositry->destroy($this->model, $id);
    }
}
