<?php

namespace App\Repositries;

use App\Models\Article;

class ArticleRepository
{
    public $mainRepositry;
    public $model;
    public function __construct(MainRepository $mainRepositry, Article $model)
    {
        $this->mainRepositry = $mainRepositry;
        $this->model         = $model;
    }

    public function index()
    {
        $articles = $this->model->query();
        return $this->mainRepositry->index($articles);
    }

    public function show($id)
    {
        $article = $this->mainRepositry->show($this->model, $id);
        return $article;
    }

    public function store($data)
    {
        $article = $this->mainRepositry->create($this->model, $data);
        $article->update($data);
        return $article;
    }

    public function update($id, $data)
    {
        $article            = $this->mainRepositry->update($this->model, $id, $data);
        return $article;
    }

    public function destroy($id)
    {
        $this->mainRepositry->destroy($this->model, $id);
    }
}
