<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Http\Traits\ImageTrait;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use Astrotomic\Translatable\Translatable;

class howWeWork extends Model
{
    use ImageTrait , Translatable;
    protected $table                = 'how_we_works';
    protected $fillable             = [ 'image' ];
    public $translatedAttributes    = ['title' , 'description'];
    protected $folder               = 'howweworks';

    public static function rules()
    {
        foreach (LaravelLocalization::getSupportedLanguagesKeys() as $locale) {
            $rules[ $locale .'.title' ]         = 'required|string';
            $rules[ $locale .'.description' ]   = 'required|string';
        }
        $rules['image']         = 'image|mimes:png,jpg,jpeg|max:2048|';
        return $rules;
    }

}
