<?php

namespace App\Models;

use App\Http\Traits\ImageTrait;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use ImageTrait;

    public $folder = 'settings';

    protected $fillable = [
        'app_name',
        'image',
        'phone',
        'whatsapp',
    ];

    public static function rules()
    {
        $rules['app_name']              = 'required|min:3|max:255';
        $rules['image']                  = 'sometimes|image|mimes:png,jpg,jpeg|max:2048';
        $rules['phone']                 = 'required|min:3|max:255';
        $rules['whatsapp']              = 'required|min:3|max:255';
        return $rules;
    }
}
