<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use LaravelLocalization;
use Astrotomic\Translatable\Translatable;


class Page extends Model
{
    use Translatable;
    protected $fillable                 = ['title', 'content'];
    public $translatedAttributes        = ['title', 'content',];

    public static function rules()
    {
        foreach (LaravelLocalization::getSupportedLanguagesKeys() as $locale) {
            $rules[$locale . '.title']      = 'required|string';
            $rules[$locale . '.content']    = 'required|string';
        }
        return $rules;
    }
}
