<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ContactUs extends Model
{
    protected $table        = 'contact_us';
    protected $fillable     = ['name', 'email', 'phone', 'message', 'seen'];

    protected $appends = ['seen_text'];

    public static function rules()
    {
        return [
            'name'      => 'required|string',
            'email'     => 'required|email',
            'phone'     => 'required|string',
            'message'   => 'required|string',
        ];
    }

    public function getSeenTextAttribute()
    {
        return $this->seen ? __('lang.seen') : __('lang.unseen');
    }
}
