<?php

namespace App\Http\Traits;

use App\Mail\VerificationCode;
use Exception;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

trait VerificationTrait
{
    public function sendVerificationCode($user)
    {

        $otp = rand(10000, 99999);

        $user->update([
            'verification_code' => $otp,
            'verify_expire'     => now()->addMinutes(5),
        ]);
        try {
            Mail::to($user->email)->send(new VerificationCode($otp));
        } catch (Exception $exception) {
            Log::error($exception->getMessage());
        }

        return $otp;
    }
}
