<?php

namespace App\Http\Traits;

use App\Jobs\SendNotificationJob;
use App\Models\AdminNotification;
use App\Models\Client;

trait NotificationTrait
{

    public function createNotification($request)
    {
        $notification = AdminNotification::create($request);
        $request['amdin_notification_id'] = $notification->id;
        $this->sendNotificationClient($request['client_id'] ?? [], $request);
        return $notification;
    }
    public function sendNotificationClient($client_id, $notification)
    {
        if (in_array('all', $client_id)) {
            Client::where('status', '1')->chunkById(100, function ($clients) use ($notification) {
                $clientIds = $clients->pluck('id')->toArray();
                SendNotificationJob::dispatch($clientIds, $notification, 'Client', new Client());
            });
        } else {
            Client::where('status', '1')->whereIn('id', $client_id)->chunkById(100, function ($clients) use ($notification) {
                $clientIds = $clients->pluck('id')->toArray();
                SendNotificationJob::dispatch($clientIds, $notification, 'Client', new Client());
            });
        }
    }
}
