<?php

namespace App\Http\Requests\Admin\Client;

use App\Models\Client;
use Illuminate\Foundation\Http\FormRequest;

class ClientUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = Client::rules();
        $rules['password'] .= 'nullable';
        $rules['name'] .= $this->route('client');
        $rules['email'] .= $this->route('client');
        $rules['phone'] .= $this->route('client');
        return $rules;
    }
}
