<?php

namespace App\Http\Requests\Admin\Area;

use App\Models\Area;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class AreaRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = Area::rules();
        $rules['city_id'] .= Rule::exists('cities', 'id')->where('country_id', $this->country_id);
        return $rules;
    }
}
