<?php

namespace App\Http\Requests\API\Password;

use App\Http\Traits\ValidationTrait;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;

class ResetPasswordRequest extends FormRequest
{
    use ValidationTrait;
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'token'         => 'required|exists:otps,token',
            'new_password'          => ['required', Password::min(6)->mixedCase()->letters()->numbers()->symbols()->uncompromised()],
            // 'password_confirmation' => ['required', 'min:8', 'string', 'same:password', Password::min(6)->mixedCase()->letters()->numbers()->symbols()->uncompromised()]
            'password_confirmation' => 'required|same:new_password'
        ];
    }
}
