<?php

namespace App\Http\Requests\API\Password;

use App\Http\Traits\ValidationTrait;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;

class PasswordChangeRequest extends FormRequest
{
    use ValidationTrait;
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'old_password'          => 'required',
            'password'              => 'required|min:8|string',
            'password_confirmation' => ['required', 'min:8', 'string', 'same:password', Password::min(6)->mixedCase()->letters()->numbers()->symbols()->uncompromised()]
        ];
    }
}
