<?php

namespace App\Http\Requests\API\Authentication;

use App\Http\Traits\ValidationTrait;
use Illuminate\Foundation\Http\FormRequest;


class UpdateProfileRequest extends FormRequest
{
    use ValidationTrait;
    
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $rules['email'] = 'sometimes|email|unique:clients,email,' . auth('client')->user()->id;
        $rules['name']  = 'sometimes|string';
        $rules['phone'] = 'sometimes|string|min:11|max:11|regex:/^01[0125][0-9]{8}$/|unique:clients,phone,' . auth('client')->user()->id;
        $rules['image'] = 'sometimes|required|image|mimes:png,jpg,jpeg|max:2048';
        return $rules;
    }
}
