<?php

namespace App\Http\Requests\API\Authentication;

use App\Http\Traits\ValidationTrait;
use Illuminate\Foundation\Http\FormRequest;

class SocialLoginRequest extends FormRequest
{
    use ValidationTrait;

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'provider'  => 'required|string|in:facebook,google,apple',
            'token'     => 'required|string',
        ];
    }
}
