<?php

namespace App\Http\Middleware;

use App\Http\Traits\ResponseTrait;
use App\Http\Traits\VerificationTrait;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class IsVerifiedMiddleware
{
    use VerificationTrait, ResponseTrait;
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (auth('client')->user()->verified_at == null) {
            $this->sendVerificationCode(auth('client')->user());
            auth('client')->logout();
            return $this->response(message: __('lang.not_verified'), status: 'failed', code: 403);
        }
        return $next($request);
    }
}
