<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class IsSuperAdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, string $role = ''): Response
    {
        if (auth()->guard('web')->check()) {
            if (auth()->user()->hasAnyRole($role ? explode('|', $role) : ['superadmin'])) {
                return $next($request);
            }
            abort(403);
        }
        return $next($request);
    }
}
