<?php

namespace App\Http\Middleware;

use App\Http\Traits\ResponseTrait;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class IsActiveMiddleware
{
    use ResponseTrait;
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, $guard): Response
    {
        if (auth($guard)->user()->status == '0') {
            auth($guard)->update([
                'fcm_token' => null
            ]);
            auth($guard)->logout();
            return $this->response(
                status: 'failed',
                message: __('lang.inactive'),
                code: 422
            );
        }
        return $next($request);
    }
}
