<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\Role\RoleRequest;
use App\Http\Traits\ToasterTrait;
use App\Repositries\RoleRepository;




class RoleController extends Controller
{
    use ToasterTrait;
    public $pages       = [];
    public $permessions = [];
    public $roleRepository;
    public function __construct(RoleRepository $roleRepository)
    {
        $this->permessions = [
            'view',
            'new',
            'update',
            'delete',
        ];
        $this->pages = [
            'notifications',
            'sliders',
            'category',
            'client',
            'countries',
            'cities',
            'areas',
            'pages',
            'settings',
            'auctions',
            'messages',
            'features',
            'agencies',
        ];
        $this->roleRepository = $roleRepository;
    }

    public function index()
    {
        $roles = $this->roleRepository->index();
        return view('AdminPanel.roles.index', get_defined_vars());
    }


    public function create()
    {
        $permessions = $this->permessions;
        $pages = $this->pages;
        return view('AdminPanel.roles.create', get_defined_vars());
    }


    public function store(RoleRequest $request)
    {
        $role = $this->roleRepository->create($request->validated());
        $this->success(__('lang.created'));
        return redirect()->route('roles.index');
    }

    public function edit($id)
    {

        $permessions = $this->permessions;
        $pages = $this->pages;
        $role = $this->roleRepository->show($id);
        return view('AdminPanel.roles.edit', get_defined_vars());
    }


    public function update(RoleRequest $request, $id)
    {
        $role = $this->roleRepository->update($id, $request->validated());
        $this->success(__('lang.updated'));
        return redirect()->route('roles.index');
    }


    public function destroy($id)
    {
        $role = $this->roleRepository->destroy($id);
        $this->success(__('lang.deleted'));
        return redirect()->route('roles.index');
    }
}
