<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\Page\PageRequest;
use App\Http\Traits\ToasterTrait;
use App\Models\Page;
use App\Repositries\MainRepository;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;

class PageController extends Controller implements HasMiddleware
{
    use ToasterTrait;
    public $page, $pageRepository;
    public function __construct(MainRepository $pageRepository, Page $page)
    {
        $this->page = $page;
        $this->pageRepository = $pageRepository;
    }

    public static function middleware()
    {
        return [
            new Middleware('permission:view pages', only: ['index']),
            new Middleware('permission:update pages', only: ['edit', 'update']),
        ];
    }

    public function index()
    {
        $pages = $this->pageRepository->index($this->page);
        return view('AdminPanel.pages.index', get_defined_vars());
    }

    public function edit(Page $page)
    {
        return view('AdminPanel.pages.edit', get_defined_vars());
    }


    public function update(PageRequest $request, Page $page)
    {
        $this->pageRepository->update($this->page, $page->id, $request->validated());
        $this->success(_('lang.updated'));
        return redirect()->route('pages.index');
    }
}
