<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Models\ContactUs;
use App\Repositries\MainRepository;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;

class MessageController extends Controller implements HasMiddleware
{
    public $contactRepository, $model;
    public function __construct(MainRepository $contactRepository, ContactUs $model)
    {
        $this->model           = $model;
        $this->contactRepository = $contactRepository;
    }

    public static function middleware()
    {
        return [
            new Middleware('permission:view messages', only: ['index', 'show']),
            new Middleware('permission:create messages', only: ['create', 'store']),
            new Middleware('permission:update messages', only: ['edit', 'update']),
            new Middleware('permission:delete messages', only: ['destroy']),
        ];
    }
    public function index()
    {
        $messages = $this->contactRepository->index($this->model);
        return view('AdminPanel.messages.index', get_defined_vars());
    }


    public function show(string $id)
    {

        $this->contactRepository->update($this->model->where('seen', '0'), $id, ['seen' => '1']);
        return redirect()->route('messages.index')->with('success', __('lang.updated'));
    }
}
