<?php

namespace App\Http\Controllers\AdminPanel;

use App\Models\howWeWork;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\howWeWork\CreateHowWeWorkRequest;
use App\Http\Requests\Admin\howWeWork\UpdateHowWeWorkRequest;
use App\Http\Traits\ToasterTrait;
use App\Repositries\HowWeWorkRepository;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;

class HowWeWorkController extends Controller implements HasMiddleware
{
    use ToasterTrait;
    public $howWeWork, $howWeWorkRepository;
    public function __construct(HowWeWorkRepository $howWeWorkRepository, howWeWork $howWeWork)
    {
        $this->howWeWork           = $howWeWork;
        $this->howWeWorkRepository = $howWeWorkRepository;
    }

    public static function middleware()
    {
        return [
            new Middleware('permission:view howWeWork', only: ['index']),
            new Middleware('permission:create howWeWork', only: ['create', 'store']),
            new Middleware('permission:update howWeWork', only: ['edit', 'update']),
            new Middleware('permission:delete howWeWork', only: ['destroy']),
        ];
    }

    public function index()
    {
        $howWeWorks = $this->howWeWorkRepository->index($this->howWeWork);
        return view('AdminPanel.howWeWorks.index',  get_defined_vars());
    }

    public function create()
    {
        return view('AdminPanel.howWeWorks.create');
    }

    public function store(CreateHowWeWorkRequest $request)
    {
        $data = $request->validated();
        $this->howWeWorkRepository->store($data);
        $this->success(__('lang.created'));
        return redirect()->route('howeworks.index');
    }

    public function edit(string $id)
    {
        $howWeWork = $this->howWeWorkRepository->show($id);
        return view('AdminPanel.howWeWorks.edit', get_defined_vars());
    }

    public function update(UpdateHowWeWorkRequest $request, string $id)
    {
        $data = $request->validated();
        $this->howWeWorkRepository->update($id, $data);
        $this->success(__('lang.updated'));
        return redirect()->route('howeworks.index');
    }

    public function destroy(string $id)
    {
        $this->howWeWorkRepository->destroy($id);
        $this->success(__('lang.deleted'));
        return redirect()->route('howeworks.index');
    }
}
