<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\Country\CountryRequest;
use App\Http\Traits\ToasterTrait;
use App\Models\Country;
use App\Repositries\MainRepository;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;

class CountryController extends Controller implements HasMiddleware
{
    use ToasterTrait;
    public  $countryRepository, $country;
    public function __construct(MainRepository $countryRepository, Country $country)
    {
        $this->countryRepository = $countryRepository;
        $this->country           = $country;
    }

    public static function middleware()
    {
        return [
            new Middleware('permission:view countries', only: ['index']),
            new Middleware('permission:create countries', only: ['create', 'store']),
            new Middleware('permission:update countries', only: ['edit', 'update']),
            new Middleware('permission:delete countries', only: ['destroy']),
        ];
    }
    public function index()
    {
        $countries = $this->countryRepository->index($this->country);
        return view('AdminPanel.countries.index', get_defined_vars());
    }


    public function create()
    {
        return view('AdminPanel.countries.create');
    }


    public function store(CountryRequest $request)
    {
        $this->countryRepository->create($this->country, $request->validated());
        $this->success(__('lang.created'));
        return redirect()->route('countries.index');
    }


    public function edit(string $id)
    {
        $country = $this->countryRepository->show($this->country, $id);
        return view('AdminPanel.countries.edit', get_defined_vars());
    }


    public function update(CountryRequest $request, string $id)
    {
        $data = $request->validated();
        $this->countryRepository->update($this->country, $id, $data);
        $this->success(__('lang.updated'));
        return redirect()->route('countries.index');
    }


    public function destroy(string $id)
    {
        $this->countryRepository->destroy($this->country, $id);
        $this->success(__('lang.deleted'));
        return redirect()->route('countries.index');
    }
}
