<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\Client\ClientCreateRequest;
use App\Http\Requests\Admin\Client\ClientUpdateRequest;
use App\Http\Traits\ToasterTrait;
use App\Repositries\ClientRepository;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;

class ClientController extends Controller implements HasMiddleware
{
    use ToasterTrait;
    public $clientRepository;

    public static function middleware()
    {
        return [
            new Middleware('permission:view clients', only: ['index', 'show']),
            new Middleware('permission:create clients', only: ['create', 'store']),
            new Middleware('permission:update clients', only: ['edit', 'update']),
            new Middleware('permission:delete clients', only: ['destroy']),
        ];
    }

    public function __construct(ClientRepository $clientRepository)
    {
        $this->clientRepository = $clientRepository;
    }

    public function index()
    {
        $clients = $this->clientRepository->index();
        return view('AdminPanel.clients.index', get_defined_vars());
    }

    public function create()
    {
        return view('AdminPanel.clients.create');
    }

    public function store(ClientCreateRequest $request)
    {
        $this->clientRepository->store($request->validated());
        $this->success(__('lang.created'));
        return redirect()->route('clients.index');
    }

    public function edit(string $id)
    {
        $client = $this->clientRepository->show($id);
        return view('AdminPanel.clients.edit', get_defined_vars());
    }

    public function update(ClientUpdateRequest $request, string $id)
    {
        $this->clientRepository->update($id, $request->validated());
        $this->success(__('lang.updated'));
        return redirect()->route('clients.index');
    }

    public function destroy(string $id)
    {
        $this->clientRepository->destroy($id);
        $this->success(__('lang.deleted'));
        return redirect()->route('clients.index');
    }
}
