<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\City\CityRequest;
use App\Http\Traits\ToasterTrait;
use App\Models\City;
use App\Models\Country;
use App\Repositries\MainRepository;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;

class CityController extends Controller implements HasMiddleware
{
    use ToasterTrait;
    public  $cityRepository, $city, $countries, $country;
    public function __construct(MainRepository $cityRepository, City $city, Country $country)
    {
        $this->cityRepository   = $cityRepository;
        $this->city             = $city->with(['country']);
        $this->country          = $country;
        $this->countries        = $this->cityRepository->index($this->country);
    }

    public static function middleware()
    {
        return [
            new Middleware('permission:view cities', only: ['index']),
            new Middleware('permission:create cities', only: ['create', 'store']),
            new Middleware('permission:update cities', only: ['edit', 'update']),
            new Middleware('permission:delete cities', only: ['destroy']),
        ];
    }
    public function index()
    {
        $cities = $this->cityRepository->index($this->city);
        return view('AdminPanel.cities.index', get_defined_vars());
    }

    public function create()
    {
        $countries = $this->countries;
        return view('AdminPanel.cities.create', get_defined_vars());
    }

    public function store(CityRequest $request)
    {
        $this->cityRepository->create($this->city, $request->validated());
        $this->success(__('lang.created'));
        return redirect()->route('cities.index');
    }

    public function edit(string $id)
    {
        $countries = $this->countries;
        $city = $this->cityRepository->show($this->city, $id);
        return view('AdminPanel.cities.edit', get_defined_vars());
    }


    public function update(CityRequest $request, string $id)
    {
        $data = $request->validated();
        $this->cityRepository->update($this->city, $id, $data);
        $this->success(__('lang.updated'));
        return redirect()->route('cities.index');
    }


    public function destroy(string $id)
    {
        $this->cityRepository->destroy($this->city, $id);
        $this->success(__('lang.deleted'));
        return redirect()->route('cities.index');
    }



}
