<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Http\Traits\ToasterTrait;
use Illuminate\Http\Request;

class AuthController extends Controller
{
    use ToasterTrait;
    public function login()
    {
        return view('AdminPanel.Authentication.login');
    }

    public function postLogin(Request $request)
    {
        $credentials = $request->only('email', 'password');

        if (auth('web')->attempt($credentials)) {
            if(auth('web')->user()->status == '0'){
                auth('web')->logout();
                $this->error(__('lang.inactive'));
                return redirect()->route('login');
            }
            $this->success(__('auth.success'));
            return redirect()->intended(route('dashboard'));
        } else {
            $this->error(__('auth.failed'));
            return redirect()->back();
        }
    }

    public function logout()
    {
        auth('web')->logout();
        $this->success(__('auth.logged_out_succes'));
        return redirect()->route("login");
    }
}
