<?php

namespace App\Http\Controllers\AdminPanel;

use App\Models\Article;
use App\Http\Requests\Admin\Article\ArticleCreateRequest;
use App\Http\Requests\Admin\Article\ArticleUpdateRequest;
use App\Http\Controllers\Controller;
use App\Http\Traits\ToasterTrait;
use App\Repositries\ArticleRepository;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;


class ArticleController extends Controller implements HasMiddleware
{
    use ToasterTrait;
    public $article, $articleRepository;

    public static function middleware()
    {
        return [
            new Middleware('permission:view articles', only: ['index']),
            new Middleware('permission:create articles', only: ['create', 'store']),
            new Middleware('permission:update articles', only: ['edit', 'update']),
            new Middleware('permission:delete articles', only: ['destroy']),
        ];
    }

    public function __construct(ArticleRepository $articleRepository, Article $article)
    {
        $this->$article            = $article;
        $this->articleRepository   = $articleRepository;
    }

    public function index()
    {
        $articles = $this->articleRepository->index($this->article);
        return view('AdminPanel.articles.index', get_defined_vars());
    }

    public function create()
    {
        return view('AdminPanel.articles.create');
    }

    public function store(ArticleCreateRequest $request)
    {
        $data = $request->validated();
        $this->articleRepository->store($data);
        $this->success(__('lang.created'));
        return redirect()->route('articles.index');
    }

    public function edit(string $id)
    {
        $article = $this->articleRepository->show($id);
        return view('AdminPanel.articles.edit', get_defined_vars());
    }

    public function update(ArticleUpdateRequest $request, string $id)
    {
        $data    = $request->validated();
        $article = $this->articleRepository->update($id, $data);
        $this->success(__('lang.updated'));
        return redirect()->route('articles.index');
    }

    public function destroy(string $id)
    {
        $this->articleRepository->destroy($id);
        $this->success(__('lang.deleted'));
        return redirect()->route('articles.index');
    }
}
