<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\Admin\AdminCreateRequest;
use App\Http\Requests\Admin\Admin\AdminUpdateRequest;
use App\Http\Traits\ToasterTrait;
use App\Repositries\AdminRepository;
use App\Repositries\RoleRepository;


class AdminController extends Controller
{
    use ToasterTrait;

    public $adminRepository;
    public $roles;
    public function __construct(AdminRepository $adminRepository, RoleRepository $roleRepository)
    {
        $this->adminRepository = $adminRepository;
        $this->roles = $roleRepository->index();
    }
    public function index()
    {
        $admins = $this->adminRepository->index();
        return view('AdminPanel.admins.index', get_defined_vars());
    }

    public function create()
    {
        $roles = $this->roles;
        return view('AdminPanel.admins.create', get_defined_vars());
    }

    public function store(AdminCreateRequest  $request)
    {
        $admin = $this->adminRepository->store($request->validated());
        $this->success(__('lang.created'));
        return redirect()->route('admins.index');
    }

    public function edit($id)
    {

        $roles = $this->roles;
        $admin = $this->adminRepository->show($id);
        return view('AdminPanel.admins.edit', get_defined_vars());
    }

    public function update(AdminUpdateRequest $request, $id)
    {
        $admin = $this->adminRepository->update($id, $request->validated());
        $this->success(__('lang.updated'));
        return redirect()->route('admins.index');
    }

    public function destroy($id)
    {
        $this->adminRepository->destroy($id);
        $this->success(__('lang.deleted'));
        return redirect()->route('admins.index');
    }
}
