<?php

namespace App\Http\Controllers\API\Setting;

use App\Http\Controllers\Controller;
use App\Http\Traits\ResponseTrait;
use App\Models\Setting;
use App\Repositries\MainRepository;

class SettingController extends Controller
{
    use ResponseTrait;
    public $settingRepository, $setting;
    public function __construct(MainRepository $settingRepository, Setting $setting)
    {
        $this->settingRepository = $settingRepository;
        $this->setting = $setting;
    }
    public function __invoke()
    {
        $setting = $this->settingRepository->show($this->setting, $id = 1);
        return $this->response(data: $setting);
    }
}
