<?php

namespace App\Http\Controllers\API\Pages;

use App\Http\Controllers\Controller;
use App\Http\Traits\ResponseTrait;
use App\Models\Page;
use App\Repositries\MainRepository;

class PageController extends Controller
{
    use ResponseTrait;
    public $pageRepository, $model;

    public function __construct(MainRepository $pageRepository, Page $model)
    {
        $this->pageRepository = $pageRepository;
        $this->model = $model;
    }


    public function index()
    {
        $pages = $this->pageRepository->index($this->model);
        return $this->response(
            data: $pages
        );
    }

    public function show(string $id)
    {
        $page = $this->pageRepository->show($this->model, $id);

        return $this->response(
            data: $page
        );
    }
}
