<?php

namespace App\Http\Controllers\API\Home;

use App\Http\Controllers\Controller;
use App\Http\Traits\ResponseTrait;
use App\Repositries\AuctionRepository;
use App\Repositries\SliderRepository;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    use ResponseTrait;
    public $autionRepository,
        $sliderRepository;

    public function __construct(AuctionRepository $auctionRepository, SliderRepository $sliderRepository)
    {
        $this->autionRepository = $auctionRepository;
        $this->sliderRepository = $sliderRepository;
    }
    public function __invoke(Request $request)
    {
        $data['sliders'] = $this->sliderRepository->index();
        $filters = [
            'is_home' => '1'
        ];
        $data['auctions'] = $this->autionRepository->index($filters);
        return $this->response(data: $data);
    }
}
